    /**
    *
    * copyright (c) 2013-2019 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    //usata in tutte le pagine dell'amministrazione quando l'utente vuole cambiare password
    function validazionePassword() {
        var pass  = $('#cambiaPassword').val();
        var pass2 = $('#cambiaPassword2').val();
        if(pass==pass2 && pass!="") {
            document.formCambiaPassword.submit();
        }
        else if(pass=="") {
            alert("il campo password è vuoto");
        }
        else {
            alert("le password devono coincidere");
        }
    }

    function aggiungiRisposta(bloccaLink,idDomanda,inRispostaA) {
        if(inRispostaA==0) {
            var offsetId = "";
        }
        else {
            var offsetId = ""+inRispostaA;
        }

        var checboxPrivacy = document.getElementById("accettazioneTerminiCondizioni"+offsetId);
        if(checboxPrivacy.checked==false) {
            alert("Devi accettare le condizioni sulla privacy");
        }
        else {
            var testo     = tinyMCE.activeEditor.getContent();
            if(testo.indexOf("<script>")>-1 || testo.indexOf("<iframe")>-1 || testo.indexOf("<img")>-1) {
                alert("Rilevato tentativo di javascript injection: elimina il codice javascript prima di commentare");
            }
            else if (testo.length<1) {
                alert("inserisci il testo del commento");
            }
            else {
                if(bloccaLink=="si") {
                    if(testo.indexOf("http")>-1 || testo.indexOf("https")>-1 || testo.indexOf("www.")>-1) {
                        alert("Non è consentito inviare link. Eliminalo prima di commentare");
                    }
                    else {
                        $.ajax({
                            type:"POST",
                            url:"controller/controllerRisposte.php",
                            data:{
                                operazione:"crea",
                                idDomanda:idDomanda,
                                inRispostaA:inRispostaA,
                                testo:testo
                            },
                            success:function(result) {
                                if(inRispostaA==0) {
                                    var vecchioCodice = $("#risposte").html();
                                    $("#risposte").html(vecchioCodice+result);
                                }
                                else {
                                    var vecchioCodice = $("#risposteRisposta"+inRispostaA).html();
                                    $("#risposteRisposta"+inRispostaA).html(vecchioCodice+result);
                                }
                                tinyMCE.activeEditor.setContent('');
                            },
                            error: function() {
                                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                            }
                        });
                    }
                }
                else {
                    $.ajax({
                        type:"POST",
                        url:"controller/controllerRisposta.php",
                        data:{
                            operazione:"crea",
                            idDomanda:idDomanda,
                            inRispostaA:inRispostaA,
                            testo:testo
                        },
                        success:function(result) {
                            alert(result);
                            var vecchioCodice = $("#risposte").html();
                            $("#risposte").html(vecchioCodice+result);
                        },
                        error: function() {
                            alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                        }
                    });
                }
            }
        }
    }

    //funzione di invio dati. Titolo e testo sono campi obbligatori, se non sono stati inseriti viene visualizzato un messaggio
    function salvaContenuto() {
        if($('#titoloPagina').val()=="") {
            alert("Inserisci il titolo");
        }
        else {
            document.formCreaPagina.submit();
        }
    }
    
    //funzione di invio dati. Titolo e testo sono campi obbligatori, se non sono stati inseriti viene visualizzato un messaggio
    function pubblicaContenuto() {
        if($('#titoloPagina').val()=="") {
            alert("Inserisci il titolo");
        }
        else {
            document.getElementById("statoPubblicato").checked = true;
            document.formCreaPagina.submit();
        }
    }
     
    function eliminaFotoProfilo() {
	$.ajax({
	    type:"POST",
	    url:"utenti/cambiaImmaginiUtente.php",
	    data:{
		operazione:"eliminaFotoProfilo",
	    },
	    success:function(result) {
		if(result=="ok") {
		    document.getElementById("fotoUtente").src="immagini/altro/segnaPostoUtente.png";
		}
	    },
	    error: function() {
		alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
	    }
	});
    }
    
    // funzione per l'invio dell'email
    function invia(moduloContatto,richiediAccettazioneCondizioniPrivacy,urlRedirect) {
        var valida   = true;
        var nomeForm = "form"+moduloContatto;
        var form = document.getElementById(nomeForm);
        var i, j, q = [];
        for (i = form.elements.length - 1; i >= 0; i = i - 1) {
            if (form.elements[i].name === "") {
                continue;
            }
            switch (form.elements[i].nodeName) {
                    case 'INPUT':
                        switch (form.elements[i].type) {
                        case 'text':
                            if(form.elements[i].hasAttribute('required') && form.elements[i].value.length<1) {
                                alert("Il campo "+ form.elements[i].name +" è richiesto");
                                valida=false;
                            }
                            else {                            
                               q.push(form.elements[i].name + ":" + encodeURIComponent(form.elements[i].value));
                            }
                            break;
                        case 'email':
                            if(form.elements[i].hasAttribute('required') && form.elements[i].value.length<1) {
                                alert("Il campo "+ form.elements[i].name +" è richiesto");
                                valida=false;
                            }
                            else {                            
                               q.push(form.elements[i].name + ":" + encodeURIComponent(form.elements[i].value));
                            }
                            break;
                        case 'hidden':
                        case 'password':
                        case 'button':
                        case 'reset':
                        case 'checkbox':
                            if(form.elements[i].hasAttribute('required') && form.elements[i].checked==false) {
                                alert("Il campo "+ form.elements[i].name +" è richiesto");
                                valida=false;
                            }
                            else {                            
                               q.push(form.elements[i].name + ":" + encodeURIComponent(form.elements[i].value));
                            }
                            break;
                        case 'radio':
                             if (form.elements[i].checked) {
                                 q.push(form.elements[i].name + ":" + encodeURIComponent(form.elements[i].value));
                             }
                             break;
                        }
                        break;
                    case 'file':
                        break;
                    case 'TEXTAREA':
                        if(form.elements[i].hasAttribute('required') && form.elements[i].value.length<1) {
                            alert("Il campo "+ form.elements[i].name +" è richiesto");
                            valida=false;
                        }
                        else {                            
                           q.push(form.elements[i].name + ": " + encodeURIComponent(form.elements[i].value));
                        }
                        break;
                    case 'SELECT':
                        switch (form.elements[i].type) {
                        case 'select-one':
                             q.push(form.elements[i].name + "=" + encodeURIComponent(form.elements[i].value));
                             break;
                        case 'select-multiple':
                             for (j = form.elements[i].options.length - 1; j >= 0; j = j - 1) {
                                 if (form.elements[i].options[j].selected) {
                                     q.push(form.elements[i].name + ":" + encodeURIComponent(form.elements[i].options[j].value));
                                 }
                             }
                             break;
                        }
                        break;
            }
            data = q.join("<br>");
        }

        if(richiediAccettazioneCondizioniPrivacy=="si" && valida==true) {
            var checboxPrivacy = document.getElementById("accettazioneTerminiCondizioni");
            if(checboxPrivacy.checked==false) {            
                alert("Devi accettare le condizioni sulla privacy");
            }
            else {
                if(valida==true) {
                    $.ajax({
                        type:"POST",
                        url:"mail.php",
                        data:"idForm="+moduloContatto+"&informazioniInserite="+data,
                        success:function(risposta) {
                            if(risposta=="ok") {
                                location.href = urlRedirect;
                            }
                            else {
                                alert(risposta);
                            }
                        }
                    });
                }
            }
        }
        else {
            if(valida==true) {
                $.ajax({
                    type:"POST",
                    url:"mail.php",
                    data:"idForm="+moduloContatto+"&informazioniInserite="+data,
                    success:function(risposta) {
                        if(risposta=="ok") {
                            location.href = urlRedirect;
                        }
                        else {
                            alert(risposta);
                        }
                    }
                });
            }
        }
        
    }

                    /*** FUNZIONI PER EFFETTUARE OPERAZIONI COMUNI ***/

    // funzione per modificare la posizione di un elemento
    // usata per modficare la posizione nelle colonne laterali
    // il campo tabella da aggiornare contiene la tabella da modificare, a seconda del valore
    // lo script modificherà la query di aggiornamento
    function modificaPosizione(tabellaDaAggiornare,idCampoInput,idVoceMenu) {
        var posizione = $('#'+idCampoInput).val();
        location.href = "operazioniComuni/aggiornaPosizione.php?tabellaDaAggiornare="+tabellaDaAggiornare+"&id="+idVoceMenu+"&posizione="+posizione;
    }

    // funzione per modificare il nome di un componente nelle colonne laterali
    // il campo tabella da aggiornare contiene la tabella da modificare, a seconda del valore
    // lo script modificherà la query di aggiornamento
    function modificaNomeComponente(tabellaDaAggiornare,idCampoInput,idVoceMenu) {
        var nomeComponente = $('#'+idCampoInput).val();
        location.href = "operazioniComuni/aggiornaNomeComponente.php?tabellaDaAggiornare="+tabellaDaAggiornare+"&id="+idVoceMenu+"&nomeComponente="+nomeComponente;
    }

    // funzione per modificare il percorso di un prodotto geecom
    // usata in impostazioni -> prodotti installati
    function modificaProdottoGeecom(idCampoInput,idProdotto) {
        var percorso = $('#'+idCampoInput).val();
        location.href = "impostazioni/aggiornaImpostazioniProdotti.php?percorso="+percorso+"&idProdotto="+idProdotto;
    }

    // funzione per modificare il percorso di un prodotto geecom
    // usata in impostazioni -> prodotti installati
    function cookieAccettati() {
        var CookieDate = new Date;
        CookieDate.setFullYear(CookieDate.getFullYear( ) +30);
        document.cookie = "cookieAccettati=si; expires=" + CookieDate.toGMTString( ) + ";";
    }

    /*
     * funzione per aggiornare tramite ajax un campo della tabella impostazioni
     */
    function aggiornaCampoImpostazioni(tabella,id,campo,valore) {
        $.ajax({
            type:"GET",
            url:"../controller/controllerImpostazioni.php",
            data:"operazione=aggiornaTabellaPersonalizzata"+"&tabella="+tabella+"&id="+id+"&campo="+campo+"&valore="+valore,
            success:function(result) {
                alert(result);
            },
            error:function(){
                alert("errore");
            }
        });
    }
    
    /*
     * funzione per aggiornare tramite ajax le impostazioni sui cookie
     */
    function aggiornaImpostazioniCookie() {
        var attivaBarraCookie = "";
        var mostraPulsanteMaggioriInformazioni = "";
        var mostraPulsanteNonAccetto = "";
        if($('#attivaBarraCookie')[0].checked===true) {
            attivaBarraCookie = "si";
        }
        else {
            attivaBarraCookie = "no";
        }
        
        if($('#mostraPulsanteMaggioriInformazioni')[0].checked===true) {
            mostraPulsanteMaggioriInformazioni = "si";
        }
        else {
            mostraPulsanteMaggioriInformazioni = "no";
        }

        if($('#mostraPulsanteNonAccetto')[0].checked===true) {
            mostraPulsanteNonAccetto = "si";
        }
        else {
            mostraPulsanteNonAccetto = "no";
        }
        
        //var testoBarraCookie = document.getElementById("testoBarraCookie").value;
        var testoBarraCookie = tinymce.activeEditor.getContent();
        var testoPulsanteAccetto = document.getElementById("testoPulsanteAccetto").value;
        var testoPulsanteNonAccetto = document.getElementById("testoPulsanteNonAccetto").value;
        var testoPulsanteMaggioriInformazioni = document.getElementById("testoPulsanteMaggioriInformazioni").value;
        var headCodiciCookie = document.getElementById("headCodiciCookie").value;
        var fineBodyCookie = document.getElementById("fineBodyCookie").value;
        var paginaMaggioriImpostazioni = document.getElementById("paginaMaggioriImpostazioni").value;
        
        $.ajax({
            type:"GET",
            url:"../controller/controllerImpostazioni.php",
            data:{
                operazione:'aggiornaImpoastazioniCookie',
                attivaBarraCookie:attivaBarraCookie,
                testoBarraCookie:testoBarraCookie,
                testoPulsanteAccetto:testoPulsanteAccetto,
                testoPulsanteNonAccetto:testoPulsanteNonAccetto,
                headCodiciCookie:headCodiciCookie,
                fineBodyCookie:fineBodyCookie,
                testoPulsanteMaggioriInformazioni:testoPulsanteMaggioriInformazioni,
                mostraPulsanteMaggioriInformazioni:mostraPulsanteMaggioriInformazioni,
                mostraPulsanteNonAccetto:mostraPulsanteNonAccetto,
                paginaMaggioriImpostazioni:paginaMaggioriImpostazioni
            },
            success:function(result) {
                alert(result);
            },
            error:function(){
              alert("errore");
            }
        });
    }
    
    /*
     * funzione che aggiorna i click ricevuti da un invito all'azione, e 
     * reindirizza l'utente nella pagina speifica
     */
    function gestisciClick(id, link,tipoOperazione) {
        $.ajax({
            type:"GET",
            url:"controller/controllerImpostazioni.php",
            data:{
                operazione:tipoOperazione,
                id:id
            },
            success:function() {
                location.href = link;
            },
            error:function(){
              alert("errore");
            }
        });
    }
    
    /*
     * funzione per settare i cookie, richiamata dal file nel template leggeCookie.php
     */
    function impostaCookie() {
        document.cookie = "leggecookie=leggecookie";
        location.reload();
    }
    
    /*
     * questa funzione viene usata per eseguire le interazioni miPiace e nonMiPiace
     * per le domande
     */
    function eseguiInterazione(azione,tipo,id) {
        if(tipo=="domanda") {
            var controller = "controllerDomande.php";
        }
        else {
            var controller = "controllerRisposte.php";
        }
        
        $.ajax({
            type:"POST",
            url:"controller/"+controller,
            data:{
                operazione:azione,
                id:id
            },
            success:function(result) {
                location.reload();
            },
            error: function() {
                alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
            }
        });
    }

    function aggiungiEtichetta(inputSorgente,tipo,divDestinazione) {
        var nome = document.getElementById(inputSorgente).value;
        if(nome=="") {
            alert("Il campo è vuoto");
        }
        else {
            $.ajax({
                type:"POST",
                url:"../controller/controllerEtichette.php",
                data:{
                    operazione:"crea",
                    id:0,
                    nome:nome,
                    tipo:tipo
                },
                success:function(codice) {
                    if(codice=="Errore: esiste già un etichetta con questo nome") {
                        alert("Errore: esiste già un etichetta con questo nome")
                    }
                    else {
                        var codiceHtmlAttuale = document.getElementById(divDestinazione).innerHTML;
                        document.getElementById(divDestinazione).innerHTML = codiceHtmlAttuale + codice;
                    }
                },
                error: function(xhr,status,error) {
                    alert(status+" "+error);
                }
            });
        }
    }
    
    function eliminaEtichetta(id) {

        $.ajax({
            type:"POST",
            url:"../controller/controllerEtichette.php",
            data:{
                operazione:"elimina",
                id:id
            },
            success:function(esito) {
                if(esito=="ok") {                
                    document.getElementById("divEtichetta"+id).className = "d-none";
                }
                else {
                    alert(esito);
                }
            },
            error: function(xhr,status,error) {
                alert(status+" "+error);
            }
        });
    }
    
    function apriPopupEliminaImmagine(idDiv,percorso) {
        document.getElementById("idDiv").value            = idDiv;
        document.getElementById("percorsoImmagine").value = percorso;
        document.getElementById("immagineDaEliminare").src= percorso;
        $('#modalEliminaImmagine').modal('show');
    }
    
    function eliminaImmagine(prefisso) {
        var idDiv    = document.getElementById("idDiv").value;
        var percorso = document.getElementById("percorsoImmagine").value;
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerRisorse.php",
            data:{
                operazione:'eliminaFileRisorsa',
                id:0,
                percorso:percorso
            },
            success:function(esito) {
                if(esito=="ok") {
                    document.getElementById(idDiv).className = "d-none";
                    $('#modalEliminaImmagine').modal('hide');
                }
            },
            error:function(){
              alert("errore");
            }
        });        
    }
    
    function apriPopupEliminaFile(idDiv,percorso) {
        document.getElementById("idDivRisorsa").value        = idDiv;
        document.getElementById("percorsoFileRisorsa").value = percorso;
        $('#testoPercorsoFile').text(percorso);
        $('#modalEliminaFile').modal('show');
    }
    
    function eliminaFileRisorsa(prefisso) {
        var idDiv    = document.getElementById("idDivRisorsa").value;
        var percorso = document.getElementById("percorsoFileRisorsa").value;
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerRisorse.php",
            data:{
                operazione:'eliminaFileRisorsa',
                id:0,
                percorso:percorso
            },
            success:function(esito) {
                if(esito=="ok") {
                    document.getElementById(idDiv).className = "d-none";
                    $('#modalEliminaFile').modal('hide');
                }
                else {
                    alert(esito);
                }
            },
            error:function() {
              alert("errore");
            }
        });
    }
    
    function segnaNotificaComeLetta(prefisso,id) {
        $.ajax({
            type:"POST",
            url:prefisso+"controller/controllerNotifiche.php",
            async:false,
            data:{
                operazione:"segnaComeLetta",
                id:id
            },
            success:function(risposta) {
                if(risposta=="ok") {
                    document.getElementById("divNotifica"+id).className = "d-none";
                }
                else {
                    alert(risposta);
                }
            }
        });
    }
    
    function segnaNotificaComeLettaConRedirect(prefisso,id,link) {
        segnaNotificaComeLetta(prefisso,id);
        location.href = link;
    }
    
    function mostraDivNotifiche() {
        document.getElementById("dropdown-notifiche").className = "shadow p-3";
        document.getElementById("campanellaNotifiche").removeEventListener("click", mostraDivNotifiche);
        document.getElementById("campanellaNotifiche").addEventListener("click", nascondiDivNotifiche);
        document.getElementById("main").addEventListener("click", nascondiDivNotifiche);
        document.getElementById("headerAdmin").addEventListener("click", nascondiDivNotifiche);
        document.getElementById("navbarCollapse").addEventListener("click", nascondiDivNotifiche);
        document.getElementById("barraSuperioreAdmin").addEventListener("click", nascondiDivNotifiche);
    }
    
    function nascondiDivNotifiche() {
        document.getElementById("dropdown-notifiche").className = "d-none";
        document.getElementById("campanellaNotifiche").addEventListener("click", mostraDivNotifiche);
        document.getElementById("campanellaNotifiche").removeEventListener("click", nascondiDivNotifiche);
    }
    
    function eseguiModificaPasswordAmministratore(prefisso) {
        var nuovaPassword    = document.getElementById("nuovaPassword").value;
        var confermaPassword = document.getElementById("confermaNuovaPassword").value;
        
        if(nuovaPassword.length==0) {
            alert("Non è possibile impostare una password vuota");
        }
        else if(nuovaPassword==confermaPassword) {
            $.ajax({
                type:"POST",
                url:prefisso+"controller/controllerUtenti.php",
                data:{
                    operazione:'modificaPasswordAmministrazione',
                    nuovaPassword:nuovaPassword
                },
                success:function(esito) {
                    if(esito=="ok") {
                        $('#modalEliminaFile').modal('hide');
                        $('#labelOperazioneCompletata').text("Password cambiata con successo");
                        $('#modalOperazioneCompletata').modal('show');
                    }
                    else {
                        alert(esito);
                    }
                },
                error:function(){
                  alert("errore");
                }
            });
        }
        else {
            alert("Le password devono coincidere");
        }
    }
    
    /*
     * funzione per aggiornare tramite ajax un campo della tabella impostazioni
     */
    function aggiornaCampoImpostazioni(tabella,id,campo,valore) {
        $.ajax({
            type:"GET",
            url:"../controller/controllerImpostazioni.php",
            data:"operazione=aggiornaCampoTabella"+"&tabella="+tabella+"&id="+id+"&campo="+campo+"&valore="+valore,
            success:function(esito) {
                if(esito!="ok") { // se l'esito ha valore diverso da ok allora c'è qualche problema, e viene mostrato a video
                    alert(esito);
                }
            },
            error:function(){
                alert("errore");
            }
        });
    }
    
    function copiaNegliAppunti(testoDaCopiare) {
        navigator.clipboard.writeText(testoDaCopiare);
        alert("Testo copiato negli appunti");
    }